using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Web.Configuration;
using System.Web.Caching;
using System.Data.SqlClient;
using System.Diagnostics;

public partial class Default_aspx : System.Web.UI.Page 
{
    // Zdarzenia strony s automatycznie wizane
    // z metodami o nastpujcych nazwach:    
    // Page_Load, Page_AbortTransaction, Page_CommitTransaction,
    // Page_DataBinding, Page_Disposed, Page_Error, Page_Init, 
    // Page_Init Complete, Page_Load, Page_LoadComplete, Page_PreInit
    // Page_PreLoad, Page_PreRender, Page_PreRenderComplete, 
    // Page_SaveStateComplete, Page_Unload

	string _connStr = "Persist Security Info=False;Integrated Security=SSPI;" +
	"database=pubs;server=localhost;Connect Timeout=30";

    protected void Page_Load(object sender, EventArgs e)
    {
		// jesli danie pocztkowe
		if (Request.QueryString.Count == 0)
		{
			// uruchomienie receptury 14.15, aby doda element sqlCache do web.config
			TestConfig();
			// przekierowanie do wasnej witryny i dodanie cigu zapytania
            // dziki temu zmiana wprowadzona w web.config zostanie uwzgldniona
            // w trakcie dziaania CreateSqlCacheDependency i SetupCacheDependencies,
            // poniewa zale one od aktualnie konfiguracji
            
            // jeli wpis zostanie utworzony i wywoany zostanie kod
            // z tego samego egzemplarza strony, konfiguracja wewntrzna
            // nie ulegnie odwieeniu i w momencie, gdy kod nie znajdzie
            // wymaganej sekcji sqlCache, wyrzucony zostanie wyjtek            
			Response.Redirect(Request.RawUrl + "?run=1");
		}
		else
		{
			// uruchomienie receptury 14.10
			CreateSqlCacheDependency(_connStr);
			// uruchomienie receptury 14.11
			SetupCacheDependencies(_connStr);
		}
    }

    #region 14.10 Wizanie tabel baz danych z pamici podrczn
    public SqlCacheDependency CreateSqlCacheDependency(string connStr)
	{
		// Ustanowienie powizania z tabel authors bazy danych.
        // Gdy tabela si zmieni, dane zostan usunite z pamici podrcznej.

        // Zapewnienie, e otrzymywane bd informacje dotyczce bazy danych.
        // Parametrem musi by rzeczywiste poczenie,
        // a NIE NAZWA cigu poczenia z web.config.
		SqlCacheDependencyAdmin.EnableNotifications(connStr);
		// Zapewnienie, e otrzymywane bd informacje dotyczce tabeli.
		SqlCacheDependencyAdmin.EnableTableForNotifications(connStr, "Authors");

		// Wielko liter jest istotna, trzeba wic zapewni, e
        // pierwszy wpis bdzie pasowa do wpisu w pliku web.config.
        // Pierwszym parametrem musi by NAZWA cigu poczenia,
        // a nie sam cig poczenia...
        return new SqlCacheDependency("pubs", "Authors");
	}
	#endregion

    #region 14.11 Zapisywanie w pamici podrcznej danych z wieloma powizaniami
    public void SetupCacheDependencies(string connStr)
    {
	    // utworzenie powizania dla pliku z honorariami, aby w przypadku
        // jego zmiany dane byy usuwane z pamici podrcznej        
	    string file = this.Server.MapPath("author_royalties.xml");
	    CacheDependency fileDep = new CacheDependency(file);

        // utworzenie SqlCacheDependency metod z receptury 14.10
	    SqlCacheDependency sqlDep = CreateSqlCacheDependency(connStr);

	    // tabela, z ktrej naley czyta dane
	    DataSet authorInfo = null;

	    // sprawdzenie, czy klucz dla bazy pubs istnieje w pamici podrcznej
        // jeli go tam nie ma, trzeba go utworzy wraz z powizaniem
        // na tabeli na serwerze SQL Server przy uyciu klasy SqlCacheDependency
        // Wskanik "this" wskazuje na klas Page strony WWW
        // i odczytuje waciwo System.Web.UI.Page
	    if (this.Cache["authorInfo"] == null)
	    {
		    // danych nie byo, trzeba wic je odczyta i zapisa w pamici podrcznej
		    authorInfo = new DataSet("AuthorInfo");

            using (SqlConnection sqlConn = new SqlConnection(connStr))
            {
                using (SqlDataAdapter adapter =
                    new SqlDataAdapter("SELECT * FROM AUTHORS", sqlConn))
                {
                    adapter.Fill(authorInfo);

                    // dodanie informacji o honorariach
                    authorInfo.ReadXml(file, XmlReadMode.InferSchema);

                    // utworzenie powizania zagregowanego, zatem jeli baza danych
                    // lub plik si zmieni, dane zostan usunite z pamici podrcznej                    
                    AggregateCacheDependency aggDep = new AggregateCacheDependency();
                    // dodanie obydwu powiza do powizania zagregowanego
                    aggDep.Add(new CacheDependency[] { sqlDep, fileDep });

                    // dodanie zestawu danych o autorach do pamici podrcznej
                    // wraz ze zagregowanym powizaniem, by w razie zmiany zestawu
                    // dane byy odwieane w pamici podrcznej
                    this.Cache.Insert("authorInfo", authorInfo, aggDep);
                }
            }
	    }
	    else
	    {
		    authorInfo = (DataSet)this.Cache["authorInfo"];
	    }
    }
	#endregion

    #region 14.15 Analiza i zmiana konfiguracji aplikacji sieciowej
    public void TestConfig()
		{
			try
			{
				// odczytanie pliku web.config aplikacji
				System.Configuration.Configuration cfg = WebConfigurationManager.OpenWebConfiguration(@"/CSCBWeb");
				// pobranie obiektu sqlCacheDependencySection
				SqlCacheDependencySection sqlCacheDep = (SqlCacheDependencySection)cfg.GetSection("system.web/caching/sqlCacheDependency");
				// utworzenie nowego elementu w bazie danych dla pamici podrcznej
				SqlCacheDependencyDatabase sqlCacheDb = new SqlCacheDependencyDatabase("pubs","LocalPubs",9000000);
				// dodanie elementu bazy danych dla pamici podrcznej
				sqlCacheDep.Databases.Add(sqlCacheDb);
				// wczenie pamici podrcznej
				sqlCacheDep.Enabled = true;
				// odwieanie co minut
				sqlCacheDep.PollTime = 60000;
				// zapisanie nowych ustawie w pliku konfiguracyjnym
				cfg.Save(ConfigurationSaveMode.Modified);
			}
			catch (Exception e)
			{
				Debug.WriteLine(e.ToString());
			}
		}

	#endregion

}